<?php
if (! defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true)
	die();

$entityId = $GLOBALS["SALE_INPUT_PARAMS"]["PAYMENT"]["ID"];
list ($orderId, $paymentId) = \Bitrix\Sale\PaySystem\Manager::getIdsByPayment($entityId);

$order = \Bitrix\Sale\Order::load($orderId);
$ORDER_SUM = $order->getPrice();

$order_props = $order->getPropertyCollection();
$ORDER_MAIL = $order_props->getUserEmail()->getValue();

$m_form = "<form method='POST' target='new' action='https://www.b2bank.ru/acquiring/form.php'>
  <input type='hidden' name='m_hash_id' value='" . CSalePaySystemAction::GetParamValue("HashID") . "'>
  <input type='hidden' name='m_site_id' value='" . CSalePaySystemAction::GetParamValue("SiteID") . "'>";

$dbBasketItems = \Bitrix\Sale\Basket::loadItemsForOrder($order);
foreach ($dbBasketItems as $key => $basketItem)
{
	$key++;
	
	$m_form .= "<input type='hidden' name='m_items_name_" . $key . "' value='" . $basketItem->getField('NAME'). "'>";
	$m_form .= "<input type='hidden' name='m_items_price_" . $key . "' value='" . number_format($basketItem->getPrice(), 2, '.', '') . "'>";
	$m_form .= "<input type='hidden' name='m_items_quantity_" . $key . "' value='" . intval($basketItem->getQuantity()) . "'>";
}

$m_form .= "<input type='hidden' name='m_invoice_sum' value='" . number_format($ORDER_SUM, 2, '.', '') . "'>
  <input type='hidden' name='m_invoice_number' value='" . $orderId . "'>
  <input type='hidden' name='m_invoice_description' value='" . iconv("Windows-1251", "UTF-8", " /   #" . $orderId) . "'>
  <input type='hidden' name='m_invoice_mail' value='" . $ORDER_MAIL . "'>
	<input type='hidden' name='m_iutf8' value='0'>
	<input type='hidden' name='m_ientityid' value='".$entityId."'>
  <button type='submit' style='".GetMessage('B2BANK_BUTTON_STYLE')."'>" . iconv("Windows-1251", "UTF-8", GetMessage('B2BANK_BUTTON')) . "</button>
  </form>
	<br><br><br>";

print $m_form;
?>