<?php

class nc_payment_system_b2bank extends nc_payment_system
{

	const ERROR_SIGNATURE = 'Invalid signature';

	const ERROR_SUM = 'Invalid sum';

	const ERROR_INVOICE_NUMBER = 'Invalid invoice number';

	protected $m_invoice_sum;

	protected $m_notification;

	protected $m_code;

	protected $m_code_text;

	protected $automatic = TRUE;

	protected $accepted_currencies = array(
		'RUB'
	);

	protected $currency_map = array(
		'RUR' => 'RUB'
	);

	protected $settings = array(
		'HASHID' => null,
		'SITEID' => null
	);

	public function execute_payment_request(nc_payment_invoice $invoice)
	{
		$form = "<html>
		<body>
    	<form id='b2bank' action='https://www.b2bank.ru/acquiring/form.php' method='POST'>
      <input type='hidden' name='m_hash_id' value='" . $this->get_setting('HASHID') . "' />
			<input type='hidden' name='m_site_id' value='" . $this->get_setting('SITEID') . "' />
		  <input type='hidden' name='m_invoice_sum' value='" . $invoice->get_amount('%0.2F') . "' />
      <input type='hidden' name='m_invoice_number' value='" . $invoice->get_id() . "' />
      <input type='hidden' name='m_invoice_description' value='Netcat order " . $invoice->get('order_id') . "' />

      <input type='hidden' name='m_invoice_mail' value='" . $invoice->get('customer_email') . "' />
      	
      <br><p align=center>
			<input type='submit' style='border:0px; background-color:white; font-size:18px' value='Payment with b2bank.ru' >
			</form>
      <script>document.forms[0].submit();</script>
    </body>
    </html>";

		print $form;
	}

	/**
	 */
	public function validate_payment_request_parameters()
	{
	}

	/**
	 */
	public function on_response(nc_payment_invoice $invoice = null)
	{
		if ($this->m_code == 0)
			$result = $this->pay($invoice);
		else if ($this->m_code > 0)
			$result = $this->error($invoice);

		$this->returnJson($result);
	}

	/**
	 */
	public function validate_payment_callback_response(nc_payment_invoice $invoice = null)
	{
		if (! $invoice)
		{
			$result = array(
				'error' => array(
					'message' => 'Invalid order number'
				)
			);
			$this->returnJson($result);
		} else 
		if ($this->m_invoice_sum != $invoice->get_amount('%0.2F'))
		{
			$result = array(
				'error' => array(
					'message' => self::ERROR_SUM
				)
			);

			$this->add_error(self::ERROR_SUM);
			$invoice->set('status', nc_payment_invoice::STATUS_CALLBACK_ERROR);
			$invoice->save();

			$this->returnJson($result);
		} else
		{
			$m_notification = $this->m_notification;

			$ipos = strpos($m_notification, "-");
			$m_n1 = substr($m_notification, 0, $ipos);
			$m_n2 = substr($m_notification, $ipos + 1);

			if (hash('sha256', $m_n1 . $this->get_setting('HASHID')) != $m_n2)
			{
				$result = array(
					'error' => array(
						'message' => self::ERROR_SIGNATURE
					)
				);
				$this->add_error(self::ERROR_SIGNATURE);
				$this->returnJson($result);
			}
		}
	}

	function pay(nc_payment_invoice $invoice)
	{
		$this->on_payment_success($invoice);

		$result = array(
			'result' => array(
				'message' => $this->m_code_text
			)
		);
		return $result;
	}

	function error(nc_payment_invoice $invoice)
	{
		$this->on_payment_failure($invoice);

		$result = array(
			'result' => array(
				'message' => $this->m_code_text
			)
		);

		return $result;
	}

	function returnJson($arr)
	{
		header('Content-Type: application/json');
		return json_encode($arr);
	}

	public function load_invoice_on_callback()
	{
		$ar_callback = (array) json_decode(file_get_contents('php://input'));

		if (isset($ar_callback["m_invoice_number"]))
		{
			$this->m_invoice_sum = $ar_callback["m_invoice_sum"];
			if (strpos($this->m_invoice_sum, ".") == 0)
			{
				$ilen = strlen($this->m_invoice_sum);
				$this->m_invoice_sum = substr($this->m_invoice_sum, 0, ($ilen - 2)) . "." . substr($this->m_invoice_sum, ($ilen - 2));
			}

			$this->m_notification = $ar_callback["m_notification"];

			$this->m_code = $ar_callback["m_code"];

			$this->m_code_text = $ar_callback["m_code_text"];

			return $this->load_invoice($ar_callback["m_invoice_number"]);
		}
	}
}
