<?php

class ControllerExtensionPaymentB2bank extends Controller
{

	private $error = array();

	public function index()
	{
		$this->load->language('extension/payment/b2bank');

		$this->document->setTitle($this->language->get('heading_title'));
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate())
		{
			$this->model_setting_setting->editSetting('payment_b2bank', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		if (isset($this->error['warning']))
		{
			$data['error_warning'] = $this->error['warning'];
		} else
		{
			$data['error_warning'] = '';
		}

		if (isset($this->error['hash_id']))
		{
			$data['error_hash_id'] = $this->error['hash_id'];
		} else
		{
			$data['error_hash_id'] = '';
		}

		if (isset($this->error['site_id']))
		{
			$data['error_site_id'] = $this->error['site_id'];
		} else
		{
			$data['error_site_id'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/b2bank', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/b2bank', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		if (isset($this->request->post['payment_b2bank_hash_id']))
		{
			$data['payment_b2bank_hash_id'] = $this->request->post['payment_b2bank_hash_id'];
		} else
		{
			$data['payment_b2bank_hash_id'] = $this->config->get('payment_b2bank_hash_id');
		}

		if (isset($this->request->post['payment_b2bank_site_id']))
		{
			$data['payment_b2bank_site_id'] = $this->request->post['payment_b2bank_site_id'];
		} else
		{
			$data['payment_b2bank_site_id'] = $this->config->get('payment_b2bank_site_id');
		}

		if (isset($this->request->post['payment_b2bank_order_status_id']))
		{
			$data['payment_b2bank_order_status_id'] = $this->request->post['payment_b2bank_order_status_id'];
		} elseif ($this->config->has('payment_b2bank_order_status_id'))
		{
			$data['payment_b2bank_order_status_id'] = $this->config->get('payment_b2bank_order_status_id');
		} else
		{
			$data['payment_b2bank_order_status_id'] = '5';
		}

		if (isset($this->request->post['payment_b2bank_order_status_progress_id']))
		{
			$data['payment_b2bank_order_status_progress_id'] = $this->request->post['payment_b2bank_order_status_progress_id'];
		} elseif ($this->config->has('payment_b2bank_order_status_progress_id'))
		{
			$data['payment_b2bank_order_status_progress_id'] = $this->config->get('payment_b2bank_order_status_progress_id');
		} else
		{
			$data['payment_b2bank_order_status_progress_id'] = '2';
		}

		if (isset($this->request->post['payment_b2bank_order_status_cancelled_id']))
		{
			$data['payment_b2bank_order_status_cancelled_id'] = $this->request->post['payment_b2bank_order_status_cancelled_id'];
		} elseif ($this->config->has('payment_b2bank_order_status_cancelled_id'))
		{
			$data['payment_b2bank_order_status_cancelled_id'] = $this->config->get('payment_b2bank_order_status_cancelled_id');
		} else
		{
			$data['payment_b2bank_order_status_cancelled_id'] = '7';
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_b2bank_geo_zone_id']))
		{
			$data['payment_b2bank_geo_zone_id'] = $this->request->post['payment_b2bank_geo_zone_id'];
		} else
		{
			$data['payment_b2bank_geo_zone_id'] = $this->config->get('payment_b2bank_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['payment_b2bank_status']))
		{
			$data['payment_b2bank_status'] = $this->request->post['payment_b2bank_status'];
		} else
		{
			$data['payment_b2bank_status'] = $this->config->get('payment_b2bank_status');
		}

		if (isset($this->request->post['payment_b2bank_sort_order']))
		{
			$data['payment_b2bank_sort_order'] = $this->request->post['payment_b2bank_sort_order'];
		} else
		{
			$data['payment_b2bank_sort_order'] = $this->config->get('payment_b2bank_sort_order');
		}

		$data['notify_url'] = HTTPS_CATALOG . 'index.php?route=extension/payment/b2bank/callback';

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/b2bank', $data));
	}

	private function validate()
	{
		if (! $this->user->hasPermission('modify', 'extension/payment/b2bank'))
		{
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (! $this->request->post['payment_b2bank_hash_id'])
		{
			$this->error['hash_id'] = $this->language->get('error_hash_id');
		}

		if (! $this->request->post['payment_b2bank_site_id'])
		{
			$this->error['site_id'] = $this->language->get('error_site_id');
		}

		return ! $this->error;
	}
}