<?php

class ControllerExtensionPaymentB2bank extends Controller
{

	/**
	 */
	public function callback()
	{
		if (isset($this->request->post))
		{
			$this->createLog(__METHOD__, $this->request->post, 'Data from b2bank.ru');
		}

		$order_id = $this->request->post["m_invoice_number"];
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);

		if (! isset($this->request->post['m_hash_id']))
		{
			echo 'FAIL';
			exit();
		}

		$hash_id = $this->config->get('payment_b2bank_hash_id');

		if ($hash_id != $this->request->post['m_hash_id'])
		{
			echo 'FAIL';
			exit();
		}

		$m_notification = $this->request->post['m_notification'];

		$ipos = strpos($m_notification, "-");
		$m_n1 = substr($m_notification, 0, $ipos);
		$m_n2 = substr($m_notification, $ipos + 1);

		if (hash('sha256', $m_n1 . $hash_id) == $m_n2)
		{
			if ($order_info['order_status_id'] == 0)
			{
				$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('payment_b2bank_order_status_id'), 'Paid via b2bank.ru');
				exit();
			}

			if ($order_info['order_status_id'] != $this->config->get('payment_b2bank_order_status_id'))
			{
				$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('payment_b2bank_order_status_id'), 'b2bank.ru', true);
			}
		} else
		{
			$this->log->write("b2bank.ru sign or hash is not correct!");
		}
	}

	/**
	 */
	public function index()
	{
		$data['button_confirm'] = $this->language->get('button_confirm');
		$data['button_back'] = $this->language->get('button_back');

		$data['action'] = 'https://www.b2bank.ru/acquiring/form.php';

		$this->load->language('extension/payment/b2bank');
		$this->load->model('extension/payment/b2bank');

		$m_bag = "";

		$order_products = $this->cart->getProducts();
		foreach ($order_products as $key => $row)
		{
			$m_bag .= "<input type='hidden' name='m_items_name_" . ($key + 1) . "' value='" . $row['name'] . "'>
				<input type='hidden' name='m_items_quantity_" . ($key + 1) . "' value='" . $row['quantity'] . "'>
				<input type='hidden' name='m_items_price_" . ($key + 1) . "' value='" . $row['price'] . "'>
				<input type='hidden' name='m_items_articul_" . ($key + 1) . "' value=''" . $row['product_id'] . "'>";
		}

		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
		$data['m_hash_id'] = $this->config->get('payment_b2bank_hash_id');
		$data['m_site_id'] = $this->config->get('payment_b2bank_site_id');
		$data['m_bag'] = $m_bag;
		$data['email'] = $order_info['email'];
		$data['order_id'] = $this->session->data['order_id'];
		$data['amount'] = number_format($order_info['total'], 2, ".", "");

		$data['description'] = $this->language->get('text_order') . ' ' . $data['order_id'];
		$this->createLog(__METHOD__, $data);

		return $this->load->view('extension/payment/b2bank', $data);
	}

	/**
	 */
	public function createLog($method, $data = array(), $text = '')
	{
		if ($this->config->get('payment_b2bank_log'))
		{
			if ($method == 'index')
			{
				$order_check = array();
				foreach ($data['order_check'] as $check)
				{
					$order_check = array(
						'LMI_SHOPPINGCART.ITEMS[' . $check['pos'] . '].NAME' => $check['name'],
						'LMI_SHOPPINGCART.ITEMS[' . $check['pos'] . '].QTY' => $check['quantity'],
						'LMI_SHOPPINGCART.ITEMS[' . $check['pos'] . '].PRICE' => $check['price'],
						'LMI_SHOPPINGCART.ITEMS[' . $check['pos'] . '].TAX' => $check['tax']
					);
				}

				$data = array_merge(array(
					'LMI_MERCHANT_ID' => $data['merchant_id'],
					'LMI_PAYMENT_AMOUNT' => $data['amount'],
					'LMI_CURRENCY' => $data['lmi_currency'],
					'LMI_PAYMENT_NO' => $data['order_id'],
					'LMI_PAYMENT_DESC' => $data['description'],
					'SIGN' => $data['sign']
				), $order_check);
			}

			$this->log->write('---------PAYMASTER START LOG---------');
			$this->log->write('--- : ' . $method . '---');
			$this->log->write('---: ' . $text . '---');
			$this->log->write($data);
			$this->log->write('---------PAYMASTER END LOG---------');
		}
		return true;
	}

	/**
	 */
	public function fail()
	{
		$this->createLog(__METHOD__, '', 'Payment failed');
		$this->response->redirect($this->url->link('checkout/checkout', '', 'SSL'));
		return true;
	}

	/**
	 */
	public function success()
	{
		$request = $this->request->post;

		if (empty($request))
		{
			$request = $this->request->get;
		}

		$order_id = $request["LMI_PAYMENT_NO"];
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);

		if ((int) $order_info["order_status_id"] == (int) $this->config->get('payment_b2bank_order_status_id'))
		{
			$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('payment_b2bank_order_status_id'), 'b2bank.ru', true);
			$this->createLog(__METHOD__, $request, 'Payment completed successfully');

			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['guest']);
			unset($this->session->data['comment']);
			unset($this->session->data['order_id']);
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);
			unset($this->session->data['totals']);

			$this->cart->clear();

			$this->response->redirect($this->url->link('checkout/success', '', 'SSL'));

			return true;
		}

		return false;
	}
}
