<?php

/*
 * Plugin Name: b2bank.ru
 * Description: b2bank.ru Plugin for WooCommerce
 * Version: 2.0
 */
if (! defined('ABSPATH'))
{
	exit();
}

require_once dirname(__FILE__) . '/includes/b2bankapi.php';

function b2bank_gateway_icon($gateways)
{
	if (isset($gateways['b2bank']))
	{
		$url = WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__));
		$gateways['b2bank']->icon = $url . '/images/b2bank-logo-100.png';
	}

	return $gateways;
}

add_filter('woocommerce_available_payment_gateways', 'b2bank_gateway_icon');

add_action('plugins_loaded', 'woocommerce_b2bank_init', 0);

function woocommerce_b2bank_init()
{
	if (! class_exists('WC_Payment_Gateway'))
		return;

	class WC_Payment_B2bank extends WC_Payment_Gateway
	{

		public function __construct()
		{
			$this->id = 'b2bank';
			$this->method_title = 'b2bank.ru Internet Acquiring Service';
			$this->has_fields = false;

			$this->init_form_fields();
			$this->init_settings();

			$this->title = $this->settings['title'];
			$this->description = $this->settings['description'];

			$this->hash_id = $this->settings['hash_id'];
			$this->site_id = $this->settings['site_id'];

			$this->msg['message'] = "";
			$this->msg['class'] = "";

			if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>='))
			{
				add_action('woocommerce_update_options_payment_gateways_' . $this->id, array(
					&$this,
					'process_admin_options'
				));
			} else
			{
				add_action('woocommerce_update_options_payment_gateways', array(
					&$this,
					'process_admin_options'
				));
			}
			add_action('woocommerce_receipt_b2bank', array(
				&$this,
				'receipt_page'
			));
		}

		function init_form_fields()
		{
			$this->form_fields = array(
				'enabled' => array(
					'title' => __('On/Off', 'b2bank'),
					'type' => 'checkbox',
					'label' => __('Activate payment module b2bank.ru', 'b2bank'),
					'default' => 'no'
				),
				'title' => array(
					'title' => __('Title', 'b2bank'),
					'type' => 'text',
					'description' => __('The name that the user sees when choosing a payment type', 'b2bank'),
					'default' => __('b2bank.ru', 'b2bank')
				),
				'description' => array(
					'title' => __('Description', 'b2bank'),
					'type' => 'textarea',
					'description' => __('The description that the user sees at the time of payment ', 'b2bank'),
					'default' => __('  b2bank.ru', 'b2bank')
				),
				'hash_id' => array(
					'title' => 'HashID',
					'type' => 'text',
					'description' => __('Your HashID on the control panel b2bank.ru', 'b2bank'),
					'default' => __(' HashID      b2bank.ru', 'b2bank')
				),
				'site_id' => array(
					'title' => 'SiteID',
					'type' => 'text',
					'description' => __('Your SiteID in the control panel b2bank.ru', 'b2bank'),
					'default' => __(' SiteID      b2bank.ru', 'b2bank')
				)
			);
		}

		public function admin_options()
		{
			echo '<h3>' . __('Payment b2bank.ru', 'b2bank') . '</h3>';
			echo '<h5>' . __('To connect the Internet acquiring service, you need to register on the site ', 'b2bank');
			echo '<a href="https://b2bank.ru/">www.b2bank.ru</a>';
			echo '<table class="form-table">';
			// Generate the HTML For the settings form.
			$this->generate_settings_html();
			echo '</table>';
		}

		function payment_fields()
		{
		}

		/**
		 * Receipt Page
		 */
		function receipt_page($order)
		{
			echo $this->b2bank_form($order);
		}

		/**
		 * Exposing account
		 */
		public function b2bank_form($order_id)
		{
			$order = new WC_Order($order_id);

			$myB2BankAPI = new B2BankAPIClass($this->hash_id, $this->site_id);

			foreach ($order->get_items() as $key => $row)
			{
				$product = $order->get_product_from_item($row);

				$key ++;
				array_push($myB2BankAPI->ar_bags, array(
					'm_items_name_' . $key => iconv('UTF-8', 'Windows-1251', $row['name']),
					"m_items_quantity_" . $key => $row['quantity'],
					"m_items_price_" . $key => number_format($product->get_price(), 2, '.', ''),
					"m_items_articul_" . $key => ""
				));
			}

			$myB2BankAPI->ar_params = array(
				"m_invoice_number" => $order_id,
				"m_invoice_sum" => $order->order_total,
				"m_invoice_description" => "    #" . $order_id,
				"m_invoice_mail" => $order->billing_email
			);

			$myB2BankAPI->b2banklink();

			if ($myB2BankAPI->ar_response->m_code == 0)
				wp_redirect($myB2BankAPI->ar_response->m_url, 301);
			else
				die($myB2BankAPI->ar_response->m_code . "<br>" . $myB2BankAPI->ar_response->m_code_text . "<br>");
		}

		/**
		 * Process the payment and return the result
		 */
		function process_payment($order_id)
		{
			$order = new WC_Order($order_id);
			return array(
				'result' => 'success',
				'redirect' => $order->get_checkout_payment_url(true)
			);
		}

		function showMessage($content)
		{
			return '<div class="box ' . $this->msg['class'] . '-box">' . $this->msg['message'] . '</div>' . $content;
		}
	}

	/**
	 * Add the Gateway to WooCommerce
	 */
	function woocommerce_add_b2bank_gateway($methods)
	{
		$methods[] = 'WC_Payment_B2bank';
		return $methods;
	}
	add_filter('woocommerce_payment_gateways', 'woocommerce_add_b2bank_gateway');
}
?>